/******************************************************************************
A Trigger that plays the *BeepSound* at the trigger location or for the
instigator only when triggered.
Additional 4 more *Messages* can be send with a time delay. Within this time
the Trigger does not receive Events and touching is ignored.

SeriousBarbie AT barbies DOT world

Changelog:

2025-09-12, version 4
* fixed a bug that when having multi messages no Event is risen and
  bTriggerOnceOnly and RepeatTriggerTime are ignored

2025-08-31, version 3
+ added conversion to FLOAT for the PlaySound() BYTE parameters to avoid
  integer division
* fixed a bug that first activation of multi messages failed
+ added/corrected changelog for v0 and v1

2025-07-18, version 2
+ added *Messages* and *MessageDelays*
+ added *bBeepOnEveryMessage*
+ new icon texture
* changed default RetriggerDelay from 0 to 2
* changed default BeepSound from NONE to Sound'UnrealShare.Pickups.TransA3'

2016-09-29, version 1
+ added *bPlayForInstigatorOnly*

2016-02-18, version 0
+ Initial release
******************************************************************************/

class SBBeepTrigger extends Trigger;

#exec TEXTURE IMPORT NAME=SBBeepTrigger FILE=Textures\SBBeepTrigger.pcx MIPS=OFF FLAGS=2

var(BeepSound) sound BeepSound;
var(BeepSound) byte BeepSoundVolume;
var(BeepSound) byte BeepSoundRadius;
var(BeepSound) byte BeepSoundPitch; // Sound pitch shift, 64.0=none.
var(BeepSound) bool bPlayForInstigatorOnly;
var(BeepSound) bool bBeepOnEveryMessage;

var(Trigger) string Messages[4];
var(Trigger) float MessageDelays[4];

var bool bBeepSoundNoOverride;
var byte i;// Internal counter
var PlayerPawn Toucher;
var name NextState;
var bool bHaveMultiMessages;
//var bool bHaveMultiMessagesChecked;
var float MessageDelaySum;



event DoBeep(PlayerPawn Listener) {
	if (BeepSound != None)
		if (bPlayForInstigatorOnly && Listener != None)
			Listener.ClientPlaySound(BeepSound, true, true);
		else
			PlaySound(BeepSound, SLOT_Interact, float(BeepSoundVolume) / 128, bBeepSoundNoOverride, float(BeepSoundRadius) * 25, float(BeepSoundPitch) / 64);

}



event DoMessage(PlayerPawn Toucher, string AMessage, bool bDoBeep) {
	Toucher.ClientMessage(AMessage);
	if (bDoBeep)
		DoBeep(Toucher);
}


/*
function Bool HaveMultiMessages(){
	if ( ! bHaveMultiMessagesChecked)
	{
		for (i = 0; i < ArrayCount(Messages); i++)
			if (Messages[i] != "")
			{
				bHaveMultiMessages = true;
				break;
			}
		bHaveMultiMessagesChecked = true;
	}
	return bHaveMultiMessages;
}
*/


event PostBeginPlay() {
local byte i;

	Super.PostBeginPlay();
	for (i = 0; i < ArrayCount(Messages); i++)
	{
		if (MessageDelays[i] > 0)
			MessageDelaySum += MessageDelays[i];
		if (Messages[i] != "")
			bHaveMultiMessages = true;
	}
}



function Touch(actor Other) {
local Actor A;

	if (IsRelevant(Other))
	{
		if (ReTriggerDelay > 0)
		{
			if ( Level.TimeSeconds - TriggerTime < ReTriggerDelay )
				return;
		}
		Toucher = PlayerPawn(Other);
		DoBeep(Toucher);
		if (Toucher != None)
		{
			if (bHaveMultiMessages)
			{
				if (Message != "") // stock message field
					DoMessage(Toucher, Message, false); // we have already beeped
				NextState = InitialState;
				if( Event != '' )
					foreach AllActors(class 'Actor', A, Event)
						A.Trigger(Other, Other.Instigator );
				if( bTriggerOnceOnly ) // Ignore future touches.
					SetCollision(False);

				GotoState('MultiMessages');
			}
		}
	}
	Super.Touch(Other); // will show *Message* when we don't have any *Messages*
}



state MultiMessages {
	ignores Touch,Trigger;

begin:
	for (i = 0; i < ArrayCount(Messages); i++)
	{
		if (MessageDelays[i] > 0)
			Sleep(MessageDelays[i]);
		if (Messages[i] != "" && Toucher != None)
			DoMessage(Toucher, Messages[i], bPlayForInstigatorOnly && bBeepOnEveryMessage);
	}
	if (MessageDelaySum < ReTriggerDelay)
		Sleep(ReTriggerDelay - MessageDelaySum);
	GotoState(NextState);
}



defaultproperties {
	BeepSound=Sound'UnrealShare.Pickups.TransA3'
	BeepSoundRadius=16
	BeepSoundVolume=128
	BeepSoundPitch=64
	bBeepSoundNoOverride=false
	bBeepOnEveryMessage=false
	bPlayForInstigatorOnly=false
	RetriggerDelay=2
	Texture=Texture'SBBeepTrigger'
}
